/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.world.decoration;

import cofh.api.world.IGeneratorParser;
import cofh.core.world.FeatureParser;
import cofh.lib.util.WeightedRandomBlock;
import cofh.lib.world.WorldGenAdvLakes;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.apache.logging.log4j.Logger;

public class LakeParser
implements IGeneratorParser {
    @Override
    public WorldGenerator parseGenerator(String string, JsonObject jsonObject, Logger logger, List<WeightedRandomBlock> list, int n, List<WeightedRandomBlock> list2) {
        boolean bl = false;
        bl = jsonObject.has("useMaterial") ? jsonObject.get("useMaterial").getAsBoolean() : bl;
        WorldGenAdvLakes worldGenAdvLakes = new WorldGenAdvLakes(list, bl ? list2 : null);
        if (jsonObject.has("outlineWithStone")) {
            worldGenAdvLakes.outlineBlock = jsonObject.get("outlineWithStone").getAsBoolean() ? Arrays.asList(new WeightedRandomBlock(Blocks.stone, 0)) : null;
        }
        ArrayList<WeightedRandomBlock> arrayList = new ArrayList<WeightedRandomBlock>();
        if (jsonObject.has("outlineBlock")) {
            if (!FeatureParser.parseResList(jsonObject.get("outlineBlock"), arrayList, true)) {
                logger.warn("Entry specifies invalid outlineBlock for 'lake' generator! Not filling!");
            } else {
                worldGenAdvLakes.outlineBlock = arrayList;
            }
            arrayList = new ArrayList();
        }
        if (jsonObject.has("gapBlock")) {
            if (!FeatureParser.parseResList(jsonObject.get("gapBlock"), arrayList, true)) {
                logger.warn("Entry specifies invalid gapBlock for 'lake' generator! Not filling!");
            } else {
                worldGenAdvLakes.gapBlock = arrayList;
            }
        }
        if (jsonObject.has("solidOutline")) {
            worldGenAdvLakes.solidOutline = jsonObject.get("solidOutline").getAsBoolean();
        }
        if (jsonObject.has("totalOutline")) {
            worldGenAdvLakes.totalOutline = jsonObject.get("totalOutline").getAsBoolean();
        }
        return worldGenAdvLakes;
    }
}

